import pandas as pd
import os
import glob

# Configuration
INPUT_FOLDER = r'c:\Users\ADMIN\OneDrive\VibeCoding\ClaudeSandboxProjects\Agentic-Working\_apps\excel-merge\_test_data'
OUTPUT_FOLDER = r'c:\Users\ADMIN\OneDrive\VibeCoding\ClaudeSandboxProjects\Agentic-Working\_apps\excel-merge\_merged'
OUTPUT_FILE = os.path.join(OUTPUT_FOLDER, 'Master-testing.xlsx')

def merge_excel_files():
    # 1. Ensure output directory exists
    if not os.path.exists(OUTPUT_FOLDER):
        os.makedirs(OUTPUT_FOLDER)
        print(f"Created output folder: {OUTPUT_FOLDER}")

    # 2. Find all Excel files
    # Use glob to find .xlsx files
    files = glob.glob(os.path.join(INPUT_FOLDER, "*.xlsx"))
    
    if not files:
        print("No Excel files found in input folder!")
        return

    print(f"Found {len(files)} files to merge:")
    for f in files:
        print(f" - {os.path.basename(f)}")

    # 3. Read and Combine
    all_data = []
    for file_path in files:
        try:
            # Read Excel file
            df = pd.read_excel(file_path)
            # Optional: Add a column to track source file
            df['Source_File'] = os.path.basename(file_path)
            all_data.append(df)
        except Exception as e:
            print(f"Error reading {file_path}: {e}")

    if not all_data:
        print("No data loaded.")
        return

    # 4. Concatenate
    print("Merging data...")
    master_df = pd.concat(all_data, ignore_index=True)

    # 5. Save to Master file
    try:
        master_df.to_excel(OUTPUT_FILE, index=False)
        print(f"✅ Success! Merged file saved to:")
        print(f"{OUTPUT_FILE}")
        print(f"Total rows: {len(master_df)}")
    except Exception as e:
        print(f"Error saving output file: {e}")

if __name__ == "__main__":
    merge_excel_files()
