import pandas as pd
import os
import random
from datetime import datetime, timedelta

def generate_data(region_name, num_rows=20):
    products = [
        {"name": "Laptop Dell XPS", "cat": "Electronics", "price": 25000000},
        {"name": "MacBook Pro", "cat": "Electronics", "price": 45000000},
        {"name": "iPhone 15", "cat": "Mobile", "price": 30000000},
        {"name": "Samsung S24", "cat": "Mobile", "price": 28000000},
        {"name": "Mechanical Keyboard", "cat": "Accessories", "price": 2500000},
        {"name": "Gaming Mouse", "cat": "Accessories", "price": 1200000},
    ]

    data = []
    start_date = datetime(2025, 12, 1)
    
    for _ in range(num_rows):
        product = random.choice(products)
        qty = random.randint(1, 10)
        date = start_date + timedelta(days=random.randint(0, 30))
        
        row = {
            "Date": date.strftime("%Y-%m-%d"),
            "Sales Order ID": f"SO-{random.randint(1000, 9999)}",
            "Region": region_name,
            "Product Name": product["name"],
            "Category": product["cat"],
            "Quantity": qty,
            "Unit Price": product["price"],
            "Total Revenue": qty * product["price"]
        }
        data.append(row)
    
    return pd.DataFrame(data)

def main():
    base_dir = os.path.dirname(os.path.abspath(__file__))
    test_dir = os.path.join(base_dir, "_test_data")
    
    if not os.path.exists(test_dir):
        os.makedirs(test_dir)
        print(f"Created directory: {test_dir}")
    
    regions = ["Hanoi", "DaNang", "HoChiMinh"]
    
    for region in regions:
        df = generate_data(region)
        file_path = os.path.join(test_dir, f"Sales_Report_{region}.xlsx")
        df.to_excel(file_path, index=False)
        print(f"Generated: {file_path}")

if __name__ == "__main__":
    main()
